﻿import QtQml
import QtQuick
import QtQuick.Controls
import QtQuick.Layouts
import QtQuick.Dialogs

import LocalFile

Rectangle {
    id: thiz
    color: Playbook.backgroundColor

    FileDialog {
        id: dlgFile
        property var ptr: null
        onAccepted:  {
            Playbook.log(dlgFile.currentFile)
            let path = Playbook.urlToLocalFile(dlgFile.currentFile)
            ptr.text = path
            if(ptr == fileGet) {
                fileSave.text = path + ".copy"
            }
        }
    }

    LocalFile {
        id: fileReader
    }

    LocalFile {
        id: fileWriter
    }

    ColumnLayout {
        anchors.fill: parent
        anchors.margins: 10
        Label {
            text: "File read path:"
        }

        RowLayout {
            Layout.fillWidth: true
            TextInput{
                Layout.fillWidth: true
                Layout.preferredHeight: 25
                verticalAlignment: TextInput.AlignVCenter
                Rectangle {
                    width: parent.width
                    height: parent.height
                    color: "#7f7f7f7f"
                    border.color: "white"
                    border.width: 1
                    radius: 3
                }
                id: fileGet
                readOnly: true
            }
            Button {
                text: "Browser"
                onClicked: {
                    dlgFile.ptr = fileGet
                    dlgFile.fileMode = FileDialog.OpenFile
                    dlgFile.open()
                }
            }
        }
        Label {
            text: "File save path:"
        }
        RowLayout {
            Layout.fillWidth: true
            MyTextField {
                Layout.fillWidth: true
                Layout.preferredHeight: 25  
                id: fileSave
                text: "/"                
            }            
            Button {
                text: "Browser"
                onClicked: {
                    dlgFile.ptr = fileSave
                    dlgFile.fileMode = FileDialog.SaveFile
                    dlgFile.open()
                }
            }
        }
        Button {
            text: "Start"
            Layout.alignment: Qt.AlignHCenter
            onClicked: {
                Playbook.logClear();
                if(!fileReader.exist(fileGet.text)){
                    Playbook.log("the file is not exist")
                    return
                }
                if(!fileWriter.open(fileSave.text, false)) {
                    Playbook.log("failed to write file:", file.errorString())
                    return;
                }
                if(!fileReader.open(fileGet.text, true)) {
                    Playbook.log("failed to read file.")
                    return
                }

                let fsize = fileReader.fileSize();
                let bsize = 1024 * 100
                let cnt = (fsize + bsize-1)  / bsize;
                for(let i = 0; i < cnt; i++) {
                    let data = fileReader.read(bsize);
                    fileWriter.write(data)
                    Playbook.log("read index.", i)
                }
                fileReader.close()
                fileWriter.close()
                Playbook.log("success to finish.")
            }
        }
        Item {
            objectName: "resizeIgnore"
            Layout.fillHeight: true
        }
    }
}
