﻿import QtQml
import QtQuick
import QtQuick.Controls
import QtQuick.Layouts
import QtQuick.Dialogs

import FileContentCommand

Rectangle {
    id: thiz
    color: Playbook.backgroundColor

    FileDialog {
        id: dlgFile
        onAccepted:  {
            fileRemote.text = Playbook.urlToLocalFile(dlgFile.fileUrl)
        }
    }

    FileContentCommand {
        id: fileContent

        onSubcommandStart: function(host){
            Playbook.log(host+": command start: ")
        }

        onSubcommandFinished: function(host,code) {
            Playbook.log(host+": command finish: exit code: "+code)
        }

        onErrorArrived: function(host,error){
            Playbook.log(error)
        }
    }

    ColumnLayout{
        anchors.fill: parent
        Label {
            text: "Remote hosts:"
        }
        RowLayout {
            Layout.fillWidth: true
            TextInput{
                Layout.fillWidth: true
                Layout.preferredHeight: 25
                verticalAlignment: TextInput.AlignVCenter
                Rectangle {
                    width: parent.width
                    height: parent.height
                    color: "#7f7f7f7f"
                    border.color: "white"
                    border.width: 1
                    radius: 3
                }
                id: hosts
                
            }
            Button {
                text: "choose"
                onClicked: {
                    let host = Playbook.hostChooser()
                    if(host === "") {
                        return;
                    }

                    if(hosts.text === "") {
                        hosts.text = host;
                    }else{
                        hosts.text += "," + host;
                    }
                }
            }
        }
        Label {
            text: "Remote file:"
        }

        RowLayout {
            Layout.fillWidth: true
            TextInput{
                Layout.fillWidth: true
                Layout.preferredHeight: 25
                verticalAlignment: TextInput.AlignVCenter
                Rectangle {
                    width: parent.width
                    height: parent.height
                    color: "#7f7f7f7f"
                    border.color: "white"
                    border.width: 1
                    radius: 3
                }
                id: fileRemote
                text: "~/fileContent.txt"
            }
        }

        Label {
            text: "FileContent:"
        }

        RowLayout {
            Layout.fillWidth: true
            MyTextField {
                Layout.fillWidth: true
                Layout.preferredHeight: 25  
                id: myContent
                text: "This is a text."                
            }
        }
        RowLayout {
            Button {
                text: "Write"
                onClicked: {
                    if(hosts.text === "") {
                        Playbook.information("Parameter error", "hosts is empty.")
                        return
                    }
                    Playbook.logClear()
                    if(false) {
                        fileContent.filePath = fileRemote.text
                        fileContent.hosts = hosts.text.split(',')
                        fileContent.content = myContent.text
                        fileContent.fileRead = false
                        fileContent.start();
                    }else{
                        asyncGenerator(function*(){
                            fileContent.hosts = hosts.text.split(',')
                            yield fileContentCommand(fileContent, fileRemote.text, myContent.text)
                            Playbook.log("fileWrite", fileContent.content);
                        })()
                    }
                }
            }
            Button {
                text: "Read"
                onClicked: {
                    if(hosts.text === "") {
                        Playbook.information("Parameter error", "hosts is empty.")
                        return
                    }
                    Playbook.logClear()
                    asyncGenerator(function*(){
                        fileContent.hosts = hosts.text.split(',')
                        yield fileContentCommand(fileContent, fileRemote.text, true)
                        Playbook.log("fileRead", fileContent.content);
                    })()
                }
            }
            Button {
                text: "Abort"
                onClicked: {
                    fileContent.abort()
                }
            }
        }

        Item {
            Layout.fillHeight: true
        }
    }
}
