﻿import QtQml
import QtQuick
import QtQuick.Controls
import QtQuick.Layouts
import QtQuick.Dialogs

import LocalCommand

Rectangle {
    id: thiz
    color: Playbook.backgroundColor

    LocalCommand {
        id: local
        onDataArrived: function(data){
            Playbook.log(data)
        }
    }

    ColumnLayout {
        anchors.fill: parent
        anchors.margins: 10
        Label {
            text: "Local command:"
        }

        RowLayout {
            Layout.fillWidth: true
            MyTextField {
                Layout.fillWidth: true
                Layout.preferredHeight: 25  
                id: cmd
                text: "ping 127.0.0.1"                
            }
        }
        Row {
            Layout.alignment: Qt.AlignHCenter
            Button {
                text: "Start"

                onClicked: {
                    Playbook.logClear();
                    if(cmd.text === "") {
                        Playbook.log("the command text is empty.")
                        return
                    }
                    asyncGenerator(function *(){
                        Playbook.log("command start.")
                        yield localCommand(local, cmd.text).catch(function(){})
                        Playbook.log("command finish.")
                    })();
                }
            }
            Button {
                text: "Abort"

                onClicked: {
                    local.abort()
                }
            }
        }
        Item {
            Layout.fillHeight: true
        }
    }
}
