﻿import QtQml
import QtQuick
import QtQuick.Controls
import QtQuick.Layouts
import QtQuick.Dialogs

import FileListCommand

Rectangle {
    id: thiz
    color: Playbook.backgroundColor

    FileListCommand {
        id: fileList

        onSubcommandStart: function(host) {
            Playbook.log(host+": command start: ")
        }

        onSubcommandFinished: function(host, code){
            Playbook.log(host+": command finish: exit code: "+code)
        }

        onErrorArrived: function(host, error){
            Playbook.log(error)
        }
    }

    ColumnLayout {
        anchors.fill: parent

        Label {
            text: "Remote hosts:"
        }

        RowLayout {
            Layout.fillWidth: true
            MyTextField {
                Layout.fillWidth: true
                Layout.preferredHeight: 25  
                id: hosts
            }            
            Button {
                text: "choose"
                onClicked: {
                    let host = Playbook.hostChooser()
                    if(host === "") {
                        return;
                    }

                    if(hosts.text === "") {
                        hosts.text = host;
                    }else{
                        hosts.text += "," + host;
                    }
                }
            }
        }

        Label {
            text: "Remote command:"
        }

        RowLayout {
            Layout.fillWidth: true
            TextInput{
                Layout.fillWidth: true
                Layout.preferredHeight: 25
                verticalAlignment: TextInput.AlignVCenter
                Rectangle {
                    width: parent.width
                    height: parent.height
                    color: "#7f7f7f7f"
                    border.color: "white"
                    border.width: 1
                    radius: 3
                }
                id: pathRemote
                text: "~"
            }
        }
        Row {
            Layout.alignment: Qt.AlignHCenter
            Button {
                text: "Start"
                onClicked: {
                    Playbook.logClear();
                    if(pathRemote.text === "") {
                        Playbook.log("the command text is empty.")
                        return
                    }
                    if(hosts.text === "") {
                        Playbook.log("the hosts is empty.")
                        return
                    }

                    asyncGenerator(function *(){
                        Playbook.log("command start.")
                        fileList.hosts = hosts.text.split(',')
                        yield fileListCommand(fileList, pathRemote.text, function(host, code){
                            Playbook.log(host+"---------------------------")
                            Playbook.log(host+"---------------------------")
                            Playbook.log(host+"---------------------------")
                            Playbook.log("show "+host+" file names----------------.")
                            Playbook.log(fileList.fileNames)
                            Playbook.log("show "+host+" file informations----------------.")
                            for(let id in fileList.fileInfos) {
                                let fi = fileList.fileInfos[id]
                                let msgs = []
                                for(let key in fi) {
                                    msgs.push(key+":"+fi[key])
                                }
                                Playbook.log(msgs.join(','))
                            }
                        })

                        Playbook.log("command finish.")
                    })();
                }
            }
            Button {
                text: "Abort"

                onClicked: {
                    remote.abort()
                }
            }
        }
        Item {
            Layout.fillHeight: true
        }
    }
}
