﻿import QtQml
import QtQuick
import QtQuick.Controls
import QtQuick.Layouts
import QtQuick.Dialogs


Rectangle {
    color: Playbook.backgroundColor
    StackView{
        id: gstack
        anchors.fill: parent

        Component {
            id: proc
            MyDeployProcess {
                onPreviousArrived: {
                    gstack.pop()
                }
            }
        }

        initialItem: MyDeployConfigure {
            onDeployArrived: function(hosts, fileLocal, fileRemote, enDesc, zhDesc){
                gstack.push(proc, {"hosts": hosts, "fileLocal":fileLocal, "fileRemote": fileRemote, "enDesc": enDesc, "zhDesc": zhDesc});
            }
        }
        pushEnter: Transition {}
        pushExit: Transition {}
        popEnter: Transition {}
        popExit: Transition {}
        replaceEnter: Transition {}
        replaceExit: Transition {}
    }
}
