﻿import QtQml
import QtQuick
import QtQuick.Controls
import QtQuick.Layouts
import QtQuick.Dialogs

import RemoteCommand

Rectangle {
    id: thiz
    color: Playbook.backgroundColor

    RemoteCommand {
        id: remote

        onSubcommandStart: function(host) {
            Playbook.log(host+": command start: "+command)
        }

        onSubcommandFinished: function(host, code){
            Playbook.log(host+": command finish: exit code: "+code)
        }

        onDataArrived: function(host,data) {
            Playbook.log(host+":"+data)
        }
        onErrorArrived: function(host, error){
            Playbook.log(error)
        }
    }

    ColumnLayout {
        anchors.fill: parent

        Label {
            text: "Remote hosts:"
        }

        RowLayout {
            Layout.fillWidth: true
            TextInput{
                Layout.fillWidth: true
                Layout.preferredHeight: 25
                verticalAlignment: TextInput.AlignVCenter
                Rectangle {
                    width: parent.width
                    height: parent.height
                    color: "#7f7f7f7f"
                    border.color: "white"
                    border.width: 1
                    radius: 3
                }
                id: hosts
            }
            Button {
                text: "choose"
                onClicked: {
                    let host = Playbook.hostChooser()
                    if(host === "") {
                        return;
                    }

                    if(hosts.text === "") {
                        hosts.text = host;
                    }else{
                        hosts.text += "," + host;
                    }
                }
            }
        }

        Label {
            text: "Remote command:"
        }

        RowLayout {
            Layout.fillWidth: true
            MyTextField {
                Layout.fillWidth: true
                Layout.preferredHeight: 25  
                id: cmd
                text: "ping -c 3 127.0.0.1"                
            }
        }
        Row {
            Layout.alignment: Qt.AlignHCenter
            Button {
                text: "Start"
                onClicked: {
                    Playbook.logClear();
                    if(cmd.text === "") {
                        Playbook.log("the command text is empty.")
                        return
                    }
                    if(hosts.text === "") {
                        Playbook.log("the hosts is empty.")
                        return
                    }

                    asyncGenerator(function *(){
                        Playbook.log("command start.")
                        remote.hosts = hosts.text.split(',')
                        yield remoteCommand(remote, cmd.text).catch(function(){})
                        Playbook.log("command finish.")
                    })();
                }
            }
            Button {
                text: "Abort"

                onClicked: {
                    remote.abort()
                }
            }
        }
        Item {
            Layout.fillHeight: true
        }
    }
}
